// VERSION :Scilab:6.0.1
// OS : WINDOWS 10
// CAPTION: Convolution sum of two sequences x(n)=[1,4,3,2] & h(n)=[1,3,2,1]
clc ;
clear all;
clc;
x=[1 4 3 2];
t1=0:1:3
subplot(2,3,1);
plot2d3(t1,x,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("Input DT Signal x(n)");

h=[1 3 2 1];
t2=0:1:3
subplot(2,3,2);
plot2d3(t2,h,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("Input DT Signal h(n)");
y=convol(x,h);
disp(y,"Convolution sum of the above two sequences is:");
// Expected output in console:
//Convolution sum of the above two sequences is:

//   1.   7.   17.   20.   16.   7.   2.

l=length(y);
t3=0:l-1;
subplot(2,3,3);
plot2d3(t3,y,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("y(n)=x(n)*h(n)");
